clearvars
close all

Lvalues = [20,40,80];
Lmarkers = {'ko','ks','k^'};
fcolour = {'r',[0.2 0.6 0.8],'g'};
formatSpec = '%f';

figure(2);
load('X.mat');

hold on, plot([X(1997,2),X(1997,2)],[0,X(1997,1)],'k--','LineWidth',3.2);
hold on, plot([1.5,6.2],[0.0175,0.0175],'k--','LineWidth',3.2);
text(7,0.0175,'Phase','FontSize',16);
text(6,0.016,'Transition','FontSize',16);

hold on, plot(X(1997:end,2),X(1997:end,1),'k-','LineWidth',3.2);
hold on, plot([1.5 6.2],[0.0132 0.0132],'k-','LineWidth',3.2);
text(7,0.0132,'Theory','FontSize',16);


for j=1:size(Lvalues,2)
    L=Lvalues(j);
    lfile=sprintf('XAlg%d.mat',L);
    load(lfile);
    figure(2), hold on, plot(A(1,:),A(2,:),Lmarkers{j},'MarkerFaceColor',fcolour{j},'MarkerSize',10);
    figure(2), hold on, plot(35,0.02-0.0025*j,Lmarkers{j},'MarkerFaceColor',fcolour{j},'MarkerSize',10);
    lLabel = sprintf('$L=%d$',L);
    text(37,0.02-0.0025*j,lLabel,'FontSize',20,'interpreter','latex');
end

xlim([0,50]);
ylim([0,0.02]);
xlabel('$\lambda$','interpreter','latex');
ylabel('$\mathcal{X}(\lambda)$','interpreter','latex');

set(gca,'FontSize',24);
set(gca,'linewidth',2);
    
saveas(gcf,'XLL.png');


for j=1:size(Lvalues,2)
    L=Lvalues(j);
    lfile=sprintf('XAlg%d.mat',L);
    load(lfile);
    figure(1), hold on, plot(A(1,:),A(2,:)*L*L,Lmarkers{j},'MarkerFaceColor',fcolour{j},'MarkerSize',10);
    figure(1), hold on, plot(4,116-20*j,Lmarkers{j},'MarkerFaceColor',fcolour{j},'MarkerSize',10);
    lLabel = sprintf('$L=%d$',L);
    text(6,115-20*j,lLabel,'FontSize',20,'interpreter','latex');
end

hold on, plot([20,20],[0,120],'k--','LineWidth',3.2);
hold on, plot([33,38],[94,94],'k--','LineWidth',3.2);
text(40,95,'Phase','FontSize',16);
text(37,86,'Transition','FontSize',16);

xlim([0,50]);
ylim([0,120]);
xlabel('$\lambda$','interpreter','latex');
ylabel('$\chi(\lambda/L^2)$','interpreter','latex');

set(gca, 'FontSize',24);
set(gca,'linewidth',2);
    
saveas(gcf,'varKoverL.png');
